/*
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License version 2 
	as published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


	Copyright (C) 2006  Thierry Berger-Perrin <tbptbp@gmail.com>
*/
#ifndef RT_H_
#define RT_H_

#include "specifics.h"


#include "rt_camera.h"
#include "rt_scene.h"
#include "rt_framebuffer.h"


namespace rt {
	enum { 
		tile_size_x = 32, // 16, // 64, // 16,
		//tile_size_x = 64,
		tile_size_y = tile_size_x 
	};


	// an awful blob of related crap.
	struct raytracer_t {
		camera_t		camera;
		scene_t			scene;

		bool_t open();
		void close();
	};

	// need another level to segregate the framebuffer, gniii.
	// for efficiency reasons, we have to keep those bundled.
	// got to walk the walk.
	struct renderer_t {
		raytracer_t		rt;
		framebuffer_t	framebuffer;

		bool_t open(const point_t &res);
		void close();
	};
}



#endif
